#include <stdio.h>
#include "mw.h"

WINDOW *windows[16];
char titles[16][20];
main()
{
int i;
int j;

    initialize_windows(FALSE,FALSE,COLOR(BROWN,BLACK,DIM));
    for (i=0;i<16;i++)
    {
        windows[i]=establish_window(POP_UP_WINDOW,((i % 8)*10)+2,((i / 8)*12)+2,9,6);
        sprintf(titles[i],"# %d",i);
        mw_set_title(windows[i],titles[i]);
        set_colors(windows[i],ALL,COLOR (i,0,DIM));
        mw_display_window(windows[i]);
        for (j=0;j<16;j++)
        {
            set_colors(windows[i],NORMAL,COLOR(i,j,DIM));
            mw_printf(windows[i],"%d ",j);
            if (j % 2)
                mw_printf(windows[i],"\n");
        }
    }
    getch();
}
#include <alloc.h>
#include "mw.h"

static struct {
                 int nw;
                 int ne;
                 int se;
                 int sw;
                 int side;
                 int top_line ;
                 int bottom_line;
              } border_characters[] =
                {
                    { 218,191,217,192,179,196,196 }, /* single line             */
                    { 201,187,188,200,186,205,205 }, /* double line             */
                    { 214,183,189,211,186,196,196 }, /* single top, double side */
                    { 213,184,190,212,179,205,205 }, /* double top, single side */
                    {  32, 32, 32, 32, 32, 32, 32 }, /* Blank border            */
                    { 220,220,223,223,219,220,223 }, /* Thick box               */
                    { 194,194,217,192,179,196,196 }  /* pop-down menu           */
                };

static void _mw_draw_title(WINDOW *wnd,unsigned char attribute);


void mw_set_title(WINDOW *wnd, char *title)
{
    wnd->title = title ;
}

void _mw_draw_frame(WINDOW *wnd)
{
register int x;
register int y;
int offset;
unsigned char border_attribute;

    if (wnd->status != WINDOW_STATUS_VISIBLE)
        return;
    if (wnd != mw_head)
        return;
    offset=0;
    if (wnd->border_type==6)
    {
        border_attribute=wnd->wcolor[BORDER] & 0xf;
        border_attribute |= mw_background_color & 0xf0;
    }
    else
        border_attribute=wnd->wcolor[BORDER];

    if (wnd->border_type)
    {
        offset=1;
        VIDEO_POKE(wnd,-1,-1, border_characters[wnd->border_type-1].nw, border_attribute);
        _mw_draw_title(wnd,border_attribute) ;
        VIDEO_POKE(wnd,wnd->width,-1,border_characters[wnd->border_type-1].ne,border_attribute);

        for (y = 0; y < wnd->height; y++)
        {
            VIDEO_POKE(wnd,-1,y,border_characters[wnd->border_type-1].side,border_attribute);
            VIDEO_POKE(wnd,wnd->width,y,border_characters[wnd->border_type-1].side,border_attribute);
        }

        VIDEO_POKE(wnd,-1,wnd->height,border_characters[wnd->border_type-1].sw,border_attribute);
        for (x = 0; x < wnd->width; x++)
            VIDEO_POKE(wnd,x,wnd->height,border_characters[wnd->border_type-1].bottom_line,border_attribute);
        VIDEO_POKE(wnd,wnd->width,wnd->height,border_characters[wnd->border_type-1].se,border_attribute);
       }
       if (wnd->shadow)
       {
           VIDEO_POKE(wnd,wnd->width+offset,0-offset,' ',mw_background_color);
           for (y = 1-offset; y <= (wnd->height+offset);y++)
               VIDEO_POKE(wnd,wnd->width+offset,y,219,mw_background_color);
           for (x = 1-offset; x <= (wnd->width+offset);x++)
               VIDEO_POKE(wnd,x,wnd->height+offset,223,mw_background_color);
           VIDEO_POKE(wnd,0-offset,wnd->height+offset,' ',mw_background_color);
        }
}

static void _mw_draw_title(WINDOW *wnd,unsigned char attribute)
{
int x1 = 0;
int i;
int ln;
char *s = wnd->title;

    if (s)
    {
        ln = strlen(s)+2 ;
        if (ln > 2)
        {
            if (ln > wnd->width)
                i = 0 ;
            else
                i = ((wnd->width-ln) / 2) ;
            if (i > 0)
                while (i--)
                    VIDEO_POKE(wnd, x1++,-1, border_characters[wnd->border_type-1].top_line, attribute) ;
            VIDEO_POKE(wnd, x1++,-1, '[', attribute) ;
            while (*s && x1 < wnd->width)
                VIDEO_POKE(wnd, x1++,-1, *s++, wnd->wcolor[TITLE]) ;
            VIDEO_POKE(wnd, x1++,-1, ']', attribute) ;
        }
     }
     while (x1 < wnd->width)
        VIDEO_POKE(wnd, x1++,-1, border_characters[wnd->border_type-1].top_line, attribute) ;
}

void mw_set_border(WINDOW *wnd, int border_type)
{
    if (border_type==0 && wnd->border_type)
        _mw_remove_border(wnd);
    else if (border_type && wnd->border_type==0)
        _mw_add_border(wnd,border_type);
    else
    {
        wnd->border_type = border_type ;
        _mw_draw_frame(wnd);
    }
}


static _mw_remove_border(WINDOW *wnd)
{
int shadow;
int rows;
int cols;

    if (wnd->status != WINDOW_STATUS_VISIBLE)
    {
        wnd->border_type=0;
        _mw_set_range(wnd);
        return;
    }

    shadow=wnd->shadow;
    if (shadow)
        mw_set_shadow(wnd,FALSE);

/*  First I restore everything that was under the border.  This erases it     */

    rows=wnd->maxy - wnd->miny + 1;
    cols=wnd->maxx - wnd->minx + 1;
    _mw_restore_row_to_screen(wnd,0,0,cols-1);
    _mw_restore_row_to_screen(wnd,rows-1,0,cols-1);
    _mw_restore_column_to_screen(wnd,0,1,rows-1);
    _mw_restore_column_to_screen(wnd,cols-1,1,rows-1);

/*  Next I resize the buffer so the border isn't there anymore                */

    _mw_resize(wnd,-2,-2,1,1,0,0);

/*  Finally I do the mop up                                                   */

    wnd->border_type=0;
    _mw_set_range(wnd);
    if (shadow)
        mw_set_shadow(wnd,TRUE);
}

static _mw_add_border(WINDOW *wnd,int border_type)
{
int shadow;
int rows;
int cols;

    if (wnd->maxx==79 || wnd->minx==0 || wnd->maxy==24 || wnd->miny==0)
    {
        mw_error_message("No room to add a border here!");
        return;
    }

    if (wnd->status != WINDOW_STATUS_VISIBLE)
    {
        wnd->border_type=border_type;
        _mw_set_range(wnd);
        return;
    }

    shadow=wnd->shadow;
    if (shadow)
        mw_set_shadow(wnd,FALSE);

/*  First I gozzle the buffer so there is space for the border                */

    if (!_mw_resize(wnd,2,2,0,0,1,1))
    {
        if (shadow)
        mw_set_shadow(wnd,TRUE);
        _mw_draw_frame(wnd);
        return;
    }

/*  Next I save the stuff that is going to go under my border                 */

    wnd->border_type=border_type;
    _mw_set_range(wnd);
    rows=wnd->maxy - wnd->miny + 1;
    cols=wnd->maxx - wnd->minx + 1;
    _mw_save_row_to_buffer(wnd,0,0,cols-1);
    _mw_save_row_to_buffer(wnd,rows-1,0,cols-1);
    _mw_save_column_to_buffer(wnd,0,1,rows-1);
    _mw_save_column_to_buffer(wnd,cols-1,1,rows-1);

/*  Finally I can draw the new border, establish the range, etc.              */

    if (shadow)
        mw_set_shadow(wnd,TRUE);
    else
        _mw_draw_frame(wnd);
}
#include "mw.h"
#pragma inline

void mw_clear_window(WINDOW *wnd)
{
register int x;
register int y ;
union element far *output_address;

    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        for (y = 0; y < wnd->height; y++)
        {
            output_address=VIDEO_ADDRESS(wnd,0,y);
            _CX = wnd->width;
            _AH = wnd->wcolor[NORMAL];
            asm push es
            asm push di
            asm les di,output_address
            asm mov al,' '
            asm rep stosw
            asm pop di
            asm pop es
        }
    }
    else if (wnd->status == WINDOW_STATUS_SAVED)
    {
        for (x=0;x<(wnd->width*wnd->height);x++)
            wnd->save_buffer[x].word=VIDEO_WORD(' ',wnd->wcolor[NORMAL]);
    }
}

void _mw_clear_screen(int background_char,int background_color)
{
    _CX = SCREEN_WIDTH*SCREEN_HEIGHT;
    asm push es
    asm push si
    asm les di,mw_screen
    asm cld
    asm mov al,background_char
    asm mov ah,background_color
    asm rep stosw
    asm pop si
    asm pop es
    mw_background_color=background_color;
    mw_background_char=background_char;
}
#include "mw.h"

void mw_set_colors(WINDOW *wnd,int area, int color)
{
int i;

    if (area == ALL)
    {
        for (i=ALL;i>=0;i--)
            wnd->wcolor[i] = color;
    }
    else
        wnd->wcolor[area] = color;
    if (area==BORDER || area==ALL || area==TITLE)
        _mw_draw_frame(wnd);
    if (area==ALL || area==NORMAL)
        mw_clear_window(wnd);
}

void mw_set_canned_colors(WINDOW *wnd,int selection)
{

    if (mw_video_mode==7)
    {
        wnd->wcolor[NORMAL] = COLOR(BLACK,WHITE,DIM) ;
        wnd->wcolor[BORDER] = COLOR(BLACK,WHITE,BRIGHT) ;
        wnd->wcolor[TITLE] = COLOR(BLACK,WHITE,BRIGHT) ;
        wnd->wcolor[SELECTED] = COLOR(BLACK,BLUE,DIM);
        wnd->wcolor[HIGHLIGHTED]= COLOR(BLACK,WHITE,BRIGHT);
        wnd->wcolor[HIGHLIGHTED_SELECTED] = COLOR(BLACK,BLUE,BRIGHT) ;
    }
    else
        switch (selection)
        {
            case 3 :
                wnd->wcolor[NORMAL] = COLOR(AQUA,BLUE,DIM);
                wnd->wcolor[BORDER] = COLOR(AQUA,BLACK,BRIGHT);
                wnd->wcolor[TITLE] = COLOR(AQUA,BLACK,DIM) ;
                wnd->wcolor[SELECTED] = COLOR(WHITE,AQUA,BRIGHT);
                wnd->wcolor[HIGHLIGHTED]= COLOR(AQUA,WHITE,BRIGHT);
                wnd->wcolor[HIGHLIGHTED_SELECTED] = COLOR(WHITE,WHITE,BRIGHT) ;
                break;
            case 2 :
                wnd->wcolor[NORMAL] = COLOR(GREEN,AQUA,BRIGHT);
                wnd->wcolor[BORDER] = COLOR(GREEN,BLACK,DIM) ;
                wnd->wcolor[TITLE] = COLOR(GREEN,BLACK,BRIGHT) ;
                wnd->wcolor[SELECTED] = COLOR(WHITE,AQUA,BRIGHT);
                wnd->wcolor[HIGHLIGHTED]= COLOR(GREEN,BROWN,BRIGHT);
                wnd->wcolor[HIGHLIGHTED_SELECTED] = COLOR(WHITE,BROWN,BRIGHT) ;
                break;
            case 1 :
                wnd->wcolor[NORMAL] = COLOR(RED,BROWN,BRIGHT) ;
                wnd->wcolor[BORDER] = COLOR(RED,BLACK,DIM) ;
                wnd->wcolor[TITLE] = COLOR(RED,BLACK,BRIGHT) ;
                wnd->wcolor[SELECTED] = COLOR(WHITE,BROWN,BRIGHT);
                wnd->wcolor[HIGHLIGHTED]= COLOR(RED,WHITE,BRIGHT);
                wnd->wcolor[HIGHLIGHTED_SELECTED] = COLOR(WHITE,RED,BRIGHT) ;
                break;
            default :
                wnd->wcolor[NORMAL] = COLOR(BLUE,WHITE,DIM) ;
                wnd->wcolor[BORDER] = COLOR(BLUE,WHITE,BRIGHT) ;
                wnd->wcolor[TITLE] = COLOR(BLUE,WHITE,BRIGHT) ;
                wnd->wcolor[SELECTED] = COLOR(WHITE,BLUE,BRIGHT);
                wnd->wcolor[HIGHLIGHTED]= COLOR(BLUE,WHITE,BRIGHT);
                wnd->wcolor[HIGHLIGHTED_SELECTED] = COLOR(WHITE,BLUE,DIM) ;
                break;
        }
    _mw_draw_frame(wnd);
    mw_clear_window(wnd);
}

void mw_accent_line(WINDOW *wnd,int color)
{
int col;

    for (col = 0; col < wnd->width; col++)
        VIDEO_POKE_ATTRIBUTE(wnd, col, wnd->selection_pointer, color) ;
}


void mw_set_attribute(WINDOW *wnd,int color)
{
    wnd->wcolor[NORMAL]=color;
}
#include <stdio.h>
#include <dos.h>
#include "mw.h"

#pragma inline

void _mw_hide_cursor(void)
{
    _AH=0x01;
    _CH=0xff;
    _CL=0xff;
    geninterrupt(0x10);
}

void _mw_position_cursor(int x, int y)
{
    _DX = ((y << 8) & 0xff00) + x;
    _AX = 0x0200;
    _BX = 0;
    geninterrupt(0x10);
}

void _mw_get_current_cursor(int *x, int *y)
{
    _AX = 0x0300;
    _BX = 0;
    geninterrupt(0x10);
    *x = _DL;
    *y = _DH;
}

void mw_set_cursor_type(WINDOW *wnd,int cursor_type)
{
    wnd->cursor_type=cursor_type;
    if (wnd==mw_head)
        _mw_display_cursor(wnd);
}

void _mw_display_cursor(WINDOW *wnd)
{
unsigned char start;
unsigned char stop;

    if (wnd == NULL || wnd != mw_head)
        return;
    if (wnd->cursor_type == CURSOR_TYPE_BLOCK)
    {
        if (mw_video_mode==7)
        {
            start=0x0;
            stop=0xd;
        }
        else
        {
            start=0;
            stop=7;
        }
    }
    else if (wnd->cursor_type == CURSOR_TYPE_LINE)
    {
        if (mw_video_mode==7)
        {
            start=0xb;
            stop=0xd;
        }
        else
        {
            start=5;
            stop=7;
        }
    }
    else
    {
         start=0x30;
         stop=0x30;
    }

    _AH=0x01;
    _CH=start;
    _CL=stop;
    geninterrupt(0x10);
    _mw_position_cursor(wnd->nw_x+wnd->cursor_x,wnd->nw_y+wnd->cursor_y);
}

void mw_gotoxy(WINDOW *wnd,int x,int y)
{
    if (x < wnd->width && y < wnd->height)
    {
        wnd->cursor_x = x ;
        wnd->cursor_y = y ;
    }
    if (wnd==mw_head)
        _mw_display_cursor(wnd);
}
#include <stdio.h>
#include "mw.h"

void mw_delete_all_windows()
{
WINDOW *sav;
WINDOW *wnd = mw_tail ;

    while (wnd)
    {
        sav = wnd->previous_window;
        mw_delete_window(wnd) ;
        wnd = sav ;
    }
}

void mw_delete_window(WINDOW *wnd)
{
    if (wnd->status == WINDOW_STATUS_VISIBLE)
        restore_screen_under_window(wnd);
    else if (wnd->status == WINDOW_STATUS_SAVED && wnd->save_buffer != NULL)
        free(wnd->save_buffer);
    mw_remove_window_from_list(wnd) ;
    free(wnd) ;
}
#include <stdio.h>
#include "mw.h"

void mw_display_window(WINDOW *wnd)
{
union element *new_buffer;

    if (wnd->status == WINDOW_STATUS_SAVED)
    {
        mw_add_window_to_head_of_list(wnd);
        wnd->status = WINDOW_STATUS_VISIBLE ;
        if (wnd->window_type != DUMB_WINDOW)
            new_buffer=_mw_save_screen_under_window_to_buffer(wnd) ;
        else
            new_buffer = NULL;
        if (wnd->save_buffer != NULL)
            _mw_restore_text_area_under_window(wnd);
        else
            mw_clear_window(wnd) ;
        wnd->save_buffer=new_buffer;
        _mw_draw_frame(wnd) ;
    }
    else if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        mw_remove_window_from_list(wnd);
        mw_add_window_to_head_of_list(wnd);
    }
    else
        mw_error_message("Unknown window status in display_window");
}

#include <stdlib.h>
#include "mw.h"

void mw_error_message(char *s)
{
WINDOW *ewnd;

        ewnd = mw_establish_window(POP_UP_WINDOW,min(50,78-strlen(s)-2), 22, 1, max(10, strlen(s)+2)) ;
        mw_set_colors(ewnd, ALL, COLOR(RED, BROWN, BRIGHT));
        mw_set_title(ewnd, "ERROR!") ;
        mw_clear_window(ewnd);
        mw_display_window(ewnd) ;
        mw_printf(ewnd," %s",s) ;
        sound(500);
        delay(100);
        sound(250);
        delay(100);
        nosound();
        mw_get_char();
        mw_delete_window(ewnd);
}

#include <stdio.h>
#include <alloc.h>
#include "mw.h"

WINDOW *mw_establish_window(int window_type,int x, int y, int height, int width)
{
WINDOW *wnd ;

    if (( wnd = (WINDOW *) malloc(sizeof (WINDOW))) == NULL)
        return NULL ;
    wnd->window_type=window_type;
    wnd->title = "" ;
    wnd->height = height;
    wnd->width = width;
    wnd->nw_x = x;
    wnd->nw_y = y;
    wnd->cursor_x = 0 ;
    wnd->cursor_y = 0 ;
    wnd->selection_pointer = 0 ;
    wnd->status = WINDOW_STATUS_SAVED;
    wnd->previous_window = NULL;
    wnd->next_window = NULL ;
    wnd->utility_1   = NULL;
    wnd->utility_2  = NULL ;
    wnd->utility_3  = NULL ;

    mw_set_cursor_type(wnd,CURSOR_TYPE_NONE);
    wnd->border_type=1;
    wnd->shadow=FALSE;
    _mw_set_range(wnd);
    if (wnd->window_type != DUMB_WINDOW)
    {
        wnd->save_buffer = malloc(wnd->width*wnd->height*2);
        mw_clear_window(wnd);
    }
    else
        wnd->save_buffer = NULL;
    mw_set_canned_colors(wnd,0);
    return(wnd);
}


#include "mw.h"

void mw_hide_window(WINDOW *wnd)
{
union element *new_buffer;

    if (wnd->status==WINDOW_STATUS_VISIBLE)
    {
        if (wnd->window_type != DUMB_WINDOW)
        {
            new_buffer=_mw_save_text_area_under_window_to_buffer(wnd);
            restore_screen_under_window(wnd);
            wnd->save_buffer=new_buffer;
        }
        else
            restore_screen_under_window(wnd);
        wnd->status=WINDOW_STATUS_SAVED;
        mw_remove_window_from_list(wnd);
     }
}

#include <stdlib.h>
#include <dos.h>
#include <alloc.h>
#include "mw.h"
#pragma inline

static int _mw_saved_x;
static int _mw_saved_y;
static int _mw_saved_top_line;
static int _mw_saved_bottom_line;
static union element (*_mw_save_buffer)[SCREEN_WIDTH];

atexit_t _mw_restore_screen_setup(void);

void mw_initialize_windows(int save_screen,int initialize_background,int color,int character)
{
int row;
int col;

    delay(1);
    _AH = 15 ;
    geninterrupt(0x10);
    mw_video_mode=_AL;
    mw_screen = (mw_video_mode == 7 ? (void far *) 0xb0000000L : (void far *) 0xb8000000L);
    mw_windows_initialized=TRUE;
    mw_background_color=color;
    _mw_store_current_setup(save_screen);
    atexit((atexit_t)_mw_restore_screen_setup);
    if (!initialize_background)
        return;
    _mw_clear_screen(character,color);
}

static _mw_store_current_setup(int save_screen)
{
int row;
int col;
union element far *output_buffer;

    _AH=3;
    geninterrupt(0x10);
    _mw_saved_x = _DL;
    _mw_saved_y = _DH;
    _mw_saved_top_line = _CH;
    _mw_saved_bottom_line = _CL;
    _mw_hide_cursor();
    if (!save_screen)
    {
        _mw_save_buffer=NULL;
        return;
    }
    _mw_save_buffer=malloc(sizeof(union element)*SCREEN_HEIGHT*SCREEN_WIDTH);
    if (_mw_save_buffer == NULL)
    {
        mw_error_message("Could not allocate storage buffer!");
        return;
    }

    output_buffer=(union element far *)_mw_save_buffer;
    _CX = SCREEN_WIDTH*SCREEN_HEIGHT;
    asm push ds
    asm push es
    asm push si
    asm push di
    asm lds si,mw_screen
    asm les di,output_buffer
    asm cld
    asm rep movsw
    asm pop di
    asm pop si
    asm pop es
    asm pop ds
}

static atexit_t _mw_restore_screen_setup(void)
{
int row;
int col;
union element far *input_buffer;

    mw_delete_all_windows();
    _AH = 0x02;
    _BX = 0;
    _DH = _mw_saved_y;
    _DL = _mw_saved_x;
    geninterrupt(0x10);
    _AH  = 0x01;
    _CH  = _mw_saved_top_line;
    _CL  = _mw_saved_bottom_line;
    geninterrupt(0x10);

    if (_mw_save_buffer==NULL)
        return;

    input_buffer=(union element far *)_mw_save_buffer;
    _CX = SCREEN_WIDTH*SCREEN_HEIGHT;
    asm push ds
    asm push es
    asm push si
    asm push di
    asm les di,mw_screen
    asm lds si,input_buffer
    asm cld
    asm rep movsw
    asm pop di
    asm pop si
    asm pop es
    asm pop ds

    free(_mw_save_buffer);
}

#include "mw.h"

int mw_get_char()
{
int c ;

    c=bioskey(0);
    if (c & 0xff)
        c &= 0xff;
    return(c);
}

int mw_scroll_lock()
{
    return(bioskey(2) & 0x10);
}
#include <stdio.h>
#include "mw.h"

void mw_add_window_to_end_of_list(WINDOW *wnd)
{
    if (mw_tail)
    {
        wnd->previous_window = mw_tail;
        mw_tail->next_window = wnd;
    }
    mw_tail = wnd ;
    if (!mw_head)
    {
        mw_head = wnd;
        _mw_display_cursor(wnd);
    }
}

void mw_add_window_to_head_of_list(WINDOW *wnd)
{
    if (mw_head)
    {
        wnd->next_window = mw_head;
        mw_head->previous_window = wnd ;
    }
    mw_head = wnd ;
    if (!mw_tail)
        mw_tail = wnd ;
    _mw_display_cursor(wnd);
}

void mw_remove_window_from_list(WINDOW *wnd)
{
    if (wnd->next_window)
        wnd->next_window->previous_window = wnd->previous_window;
    if (wnd->previous_window)
        wnd->previous_window->next_window = wnd->next_window;
    if (mw_head == wnd)
        mw_head = wnd->next_window;
    if (mw_tail == wnd)
        mw_tail = wnd->previous_window;
    wnd->next_window = NULL;
    wnd->previous_window = NULL;
    if (mw_head != NULL)
        _mw_display_cursor(mw_head);
    else
        _mw_hide_cursor();
}
/* =========== insert w1 after w2 ======================== */


void mw_insert_w1_into_list_after_w2(WINDOW *w1, WINDOW *w2)
{
    w1->previous_window = w2 ;
    w1->next_window = w2->next_window ;
    w2->next_window = w1 ;
    if (w1->next_window == NULL)
        mw_tail = w1 ;
    else
        w1->next_window->previous_window = w1 ;
}

#include <alloc.h>
#include "mw.h"

int mw_move_up(WINDOW *wnd)
{
int rows;
int cols;
int row;
int col;

    if (wnd->miny==0)
    {
        mw_error_message("Can't move any higher");
        return(FALSE);
    }
    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        rows=wnd->maxy - wnd->miny + 1;
        cols=wnd->maxx - wnd->minx + 1;

/*  Make a new buffer that has room for the line 1 am about to destroy        */
/*  Adjust miny so it looks like my window is 1 row larger than it really is  */

        if (!_mw_resize(wnd,1,0,0,0,1,0))
            return(FALSE);
        wnd->miny--;

/*  Now save the line I am going to be moving into.  It will be row 0         */

        _mw_save_row_to_buffer(wnd,0,0,cols-1);

/* Now that it is saved, I can move the window                                */

        for (row=0;row<rows;row++)
            for (col=0;col<cols;col++)
                mw_screen[wnd->miny+1+row-1][wnd->minx+col]=mw_screen[wnd->miny+1+row][wnd->minx+col];

/* Now I restore the area that was under my last row                          */

        _mw_restore_row_to_screen(wnd,rows,0,cols-1);

/* Now I need to juggle the old data in the buffer                            */
/* I also put miny back where it belongs                                      */

        _mw_resize(wnd,-1,0,0,0,0,0);
        wnd->miny++;
    }
    wnd->nw_y--;
    wnd->miny--;
    wnd->maxy--;
    _mw_display_cursor(wnd);
    return(TRUE);
}

int mw_move_down(WINDOW *wnd)
{
int rows;
int cols;
int row;
int col;

    if (wnd->maxy==24)
    {
        mw_error_message("Can't move any lower");
        return(FALSE);
    }
    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        rows=wnd->maxy - wnd->miny + 1;
        cols=wnd->maxx - wnd->minx + 1;

/*  Make a new buffer that has room for the line I am about to destroy        */
/*  Adjust miny so it looks like my window is 1 row larger than it really is  */

        if (!_mw_resize(wnd,1,0,0,0,0,0))
            return(FALSE);
        wnd->maxy++;

/*  Now save the line I am going to be moving into.  It will be row rows      */

        _mw_save_row_to_buffer(wnd,rows,0,cols-1);

/* Now that it is saved, I can move the window                                */

        for (row=rows-1;row>=0;row--)
            for (col=0;col<cols;col++)
                mw_screen[wnd->miny+row+1][wnd->minx+col]=mw_screen[wnd->miny+row][wnd->minx+col];

/* Now I restore the area that was under my first row                         */

        _mw_restore_row_to_screen(wnd,0,0,cols-1);

/* Now I need to juggle the old data in the buffer                            */
/* I also put miny back where it belongs                                      */

        _mw_resize(wnd,-1,0,1,0,0,0);
        wnd->maxy--;
    }
    wnd->nw_y++;
    wnd->miny++;
    wnd->maxy++;
    _mw_display_cursor(wnd);
    return(TRUE);
}

int mw_move_right(WINDOW *wnd)
{
int rows;
int cols;
int row;
int col;

    if (wnd->maxx==79)
    {
        mw_error_message("Can't move any farther right");
        return(FALSE);
    }
    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        rows=wnd->maxy - wnd->miny + 1;
        cols=wnd->maxx - wnd->minx + 1;

/*  Make a new buffer that has room for the column I am about to destroy      */
/*  Adjust maxx so it looks like my window is 1 col larger than it really is  */

        if (!_mw_resize(wnd,0,1,0,0,0,0))
            return(FALSE);
        wnd->maxx++;

/*  Now save the column I am going to be moving into.  It will be col cols    */

        _mw_save_column_to_buffer(wnd,cols,0,rows-1);

/* Now that it is saved, I can move the window                                */

        for (row=0;row<rows;row++)
            for (col=cols-1;col>=0;col--)
                mw_screen[wnd->miny+row][wnd->minx+col+1]=mw_screen[wnd->miny+row][wnd->minx+col];

/* Now I restore the area that was under my first column                      */

        _mw_restore_column_to_screen(wnd,0,0,rows-1);

/* Now I need to juggle the old data in the buffer                            */
/* I also put maxx back where it belongs                                      */

        _mw_resize(wnd,0,-1,0,1,0,0);
        wnd->maxx--;
    }
    wnd->nw_x++;
    wnd->minx++;
    wnd->maxx++;
    _mw_display_cursor(wnd);
    return(TRUE);
}

int mw_move_left(WINDOW *wnd)
{
int rows;
int cols;
int row;
int col;

    if (wnd->minx==0)
    {
        mw_error_message("Can't move farther left");
        return(FALSE);
    }
    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        rows=wnd->maxy - wnd->miny + 1;
        cols=wnd->maxx - wnd->minx + 1;

/*  Make a new buffer that has room for the column I am about to destroy      */
/*  Adjust minx so it looks like my window is 1 col larger than it really is  */

        if (!_mw_resize(wnd,0,1,0,0,0,1))
            return(FALSE);
        wnd->minx--;

/*  Now save the col I am going to be moving into.  It will be column 0       */

        _mw_save_column_to_buffer(wnd,0,0,rows-1);

/* Now that it is saved, I can move the window                                */

        for (row=0;row<rows;row++)
            for (col=0;col<cols;col++)
                mw_screen[wnd->miny+row][wnd->minx+1+col-1]=mw_screen[wnd->miny+row][wnd->minx+1+col];

/* Now I restore the area that was under my last column                       */

        _mw_restore_column_to_screen(wnd,cols,0,rows-1);

/* Now I need to juggle the old data in the buffer                            */
/* I also put minx back where it belongs                                      */

        _mw_resize(wnd,0,-1,0,0,0,0);
        wnd->minx++;
    }
    wnd->nw_x--;
    wnd->minx--;
    wnd->maxx--;
    _mw_display_cursor(wnd);
    return(TRUE);
}
#include <stdio.h>
#include "mw.h"

unsigned char mw_background_color=COLOR(WHITE,BLACK,DIM);
unsigned char mw_background_char=' ';
#include <stdio.h>
#include "mw.h"

void mw_poke(WINDOW *wnd, int x, int y, unsigned char character, unsigned char attribute)
{

    if (wnd->status == WINDOW_STATUS_VISIBLE)
        VIDEO_POKE(wnd, x, y, character, attribute);
    else if (wnd->save_buffer != NULL)
        wnd->save_buffer[y*wnd->width+x].word=VIDEO_WORD(character,attribute);
}
#include <stdio.h>
#include <stdarg.h>
#include "mw.h"

#define TABS 4

void mw_printf(WINDOW *wnd, char *ln, ...)
{
char dlin[100];
char *dl = dlin;

    va_list ap;
    va_start(ap, ln);
    vsprintf(dlin, ln, ap) ;
    va_end(ap) ;
    while (*dl)
        mw_putchar(wnd, *dl++);
    if (mw_head==wnd)
        _mw_position_cursor(wnd->nw_x+wnd->cursor_x,wnd->nw_y+wnd->cursor_y);
}

void mw_putchar(WINDOW *wnd, unsigned char c)
{

    switch (c)
    {
        case '\n':
            if (wnd->cursor_y == wnd->height-1)
                mw_scroll_up(wnd);
            else
                wnd->cursor_y++ ;
            wnd->cursor_x = 0 ;
            break ;
        case '\r':
            wnd->cursor_x = 0 ;
            break ;
        case '\t':
            do
                mw_putchar(wnd,' ');
            while ((wnd->cursor_x % TABS) && wnd->cursor_x < wnd->width-1) ;
            break ;
        case 8 :
            if (wnd->cursor_x)
                wnd->cursor_x--;
            break;
        default:
            if (wnd->status == WINDOW_STATUS_VISIBLE)
                VIDEO_POKE(wnd, wnd->cursor_x, wnd->cursor_y, c, wnd->wcolor[NORMAL]);
            else if (wnd->save_buffer != NULL)
                wnd->save_buffer[wnd->cursor_y*wnd->width+wnd->cursor_x].word=VIDEO_WORD(c,wnd->wcolor[NORMAL]);

            if (wnd->cursor_x < (wnd->width-1))
                wnd->cursor_x++ ;
            else
                mw_putchar(wnd,'\n');
            break ;
    }
}
#include <stdlib.h>
#include <alloc.h>
#include "mw.h"

int _mw_resize(WINDOW *wnd,int delta_rows,        int delta_cols,
                           int input_row_offset,  int input_col_offset,
                           int output_row_offset, int output_col_offset)
{
int row;
int col;
int rows;
int cols;
int rows_to_copy;
int cols_to_copy;
int new_size;
union element *target_buffer;
union element *input_address;
union element *output_address;

    if (wnd->window_type == DUMB_WINDOW)
        return(TRUE);
    rows=wnd->maxy-wnd->miny+1;
    cols=wnd->maxx-wnd->minx+1;
    new_size=(rows+delta_rows)*(cols+delta_cols)*2;
    target_buffer=malloc(new_size);
    if (target_buffer==NULL)
    {
        mw_error_message("Failed to allocate new buffer");
        return(FALSE);
    }
    rows_to_copy=min(rows-input_row_offset,rows+delta_rows-output_row_offset);
    cols_to_copy=min(cols-input_col_offset,cols+delta_cols-output_col_offset);
    for (row=0;row<rows_to_copy;row++)
        for (col=0;col<cols_to_copy;col++)
        {
            input_address=wnd->save_buffer+(row+input_row_offset)*cols+col+input_col_offset;
            output_address=target_buffer+(row+output_row_offset)*(cols+delta_cols)+col+output_col_offset;
            *output_address=*input_address;
        }
    free(wnd->save_buffer);
    wnd->save_buffer=target_buffer;
    return(TRUE);
}

void _mw_restore_column_to_screen(WINDOW *wnd,int col,int first_row,int last_row)
{
int cols;
int row;
union element *save_address;

    cols=wnd->maxx - wnd->minx + 1;
    if (wnd->window_type != DUMB_WINDOW)
    {
        for (row=first_row;row<=last_row;row++)
        {
            save_address=wnd->save_buffer + row*cols + col;
            mw_screen[wnd->miny+row][wnd->minx+col]=*save_address;
        }
    }
    else
    {
        for (row=first_row;row<=last_row;row++)
        {
            save_address=wnd->save_buffer + row*cols + col;
            mw_screen[wnd->miny+row][wnd->minx+col].word=VIDEO_WORD(' ',mw_background_color);
        }
    }
}

void _mw_restore_row_to_screen(WINDOW *wnd,int row,int first_col,int last_col)
{
int cols;
int col;
union element *save_address;

    cols=wnd->maxx - wnd->minx + 1;
    if (wnd->window_type != DUMB_WINDOW)
    {
        for (col=first_col;col<=last_col;col++)
        {
            save_address=wnd->save_buffer + row*cols + col;
            mw_screen[wnd->miny+row][wnd->minx+col]=*save_address;
        }
    }
    else
    {
        for (col=first_col;col<=last_col;col++)
        {
            save_address=wnd->save_buffer + row*cols + col;
            mw_screen[wnd->miny+row][wnd->minx+col].word=VIDEO_WORD(' ',mw_background_color);
        }
    }
}

void _mw_save_column_to_buffer(WINDOW *wnd,int col,int first_row,int last_row)
{
int cols;
int row;
union element *save_address;

    if (wnd->window_type == DUMB_WINDOW)
        return;
    cols=wnd->maxx - wnd->minx + 1;
    for (row=first_row;row<=last_row;row++)
    {
        save_address=wnd->save_buffer + row*cols + col;
        *save_address=mw_screen[wnd->miny+row][wnd->minx+col];
    }
}

void _mw_save_row_to_buffer(WINDOW *wnd,int row,int first_col,int last_col)
{
int cols;
int col;
union element *save_address;

    if (wnd->window_type == DUMB_WINDOW)
        return;
    cols=wnd->maxx - wnd->minx + 1;
    for (col=first_col;col<=last_col;col++)
    {
        save_address=wnd->save_buffer + row*cols + col;
        *save_address=mw_screen[wnd->miny+row][wnd->minx+col];
    }
}

void _mw_set_range(WINDOW *wnd)
{
int border_offset;
int shadow_offset;

    if (wnd->border_type==0)
        border_offset=0;
    else
        border_offset=1;
    if (wnd->shadow)
        shadow_offset=1;
    else
        shadow_offset=0;
    wnd->minx = wnd->nw_x - border_offset;
    wnd->miny = wnd->nw_y - border_offset;
    wnd->maxx = wnd->nw_x + wnd->width + border_offset + shadow_offset - 1;
    wnd->maxy = wnd->nw_y + wnd->height + border_offset + shadow_offset - 1;
}

#include <alloc.h>
#include "mw.h"
#pragma inline

restore_screen_under_window(WINDOW *wnd)
{
int x;
int y;
union element far *buffer;
union element far *output_address;
    if (wnd->window_type != DUMB_WINDOW)
    {
        buffer=(union element far *)wnd->save_buffer;
        for (y=wnd->miny;y<=wnd->maxy;y++)
        {
            output_address=&mw_screen[y][wnd->minx];
            _CX=wnd->maxx-wnd->minx+1;
            asm push ds
            asm push es
            asm push si
            asm push di
            asm lds si,buffer
            asm les di,output_address
            asm cld
            asm rep movsw
            asm pop di
            asm pop si
            asm pop es
            asm pop ds
            buffer += wnd->maxx-wnd->minx+1;
        }
        free((wnd->save_buffer)) ;
    }
    else
    {
        for (y=wnd->miny;y<=wnd->maxy;y++)
        {
            output_address=&mw_screen[y][wnd->minx];
            _CX=wnd->maxx-wnd->minx+1;
            asm push es
            asm push di
            asm les di,output_address
            asm cld
            asm mov al,' '
            asm mov ah,mw_background_color
            asm rep stosw
            asm pop di
            asm pop es
        }
    }
}

void _mw_restore_text_area_under_window(WINDOW *wnd)
{
    wnd->minx=wnd->nw_x;
    wnd->miny=wnd->nw_y;
    wnd->maxx=wnd->nw_x+wnd->width-1;
    wnd->maxy=wnd->nw_y+wnd->height-1;
    restore_screen_under_window(wnd);
    _mw_set_range(wnd);
}
#include <alloc.h>
#include "mw.h"
#pragma inline

void _mw_save_screen_under_window(WINDOW *wnd)
{
    wnd->save_buffer=_mw_save_screen_under_window_to_buffer(wnd);
}

union element *_mw_save_screen_under_window_to_buffer(WINDOW *wnd)
{
int x;
int y ;
union element far *buffer;
union element far *input_address;
union element *new_buffer;

    new_buffer=malloc((wnd->maxx - wnd->minx + 1)*(wnd->maxy - wnd->miny + 1)*2);
    if (new_buffer==NULL)
    {
        mw_error_message("Failed to allocate window buffer!");
        return(FALSE);
    }

    buffer=(union element far *)new_buffer;
    for (y=wnd->miny;y<=wnd->maxy;y++)
    {
        input_address=&mw_screen[y][wnd->minx];
        _CX=wnd->maxx-wnd->minx+1;
        asm push ds
        asm push es
        asm push si
        asm push di
        asm lds si,input_address
        asm les di,buffer
        asm cld
        asm rep movsw
        asm pop di
        asm pop si
        asm pop es
        asm pop ds
        buffer += wnd->maxx-wnd->minx+1;
    }
    return(new_buffer);
}

union element *_mw_save_text_area_under_window_to_buffer(WINDOW *wnd)
{
union element *new_buffer;

    wnd->minx=wnd->nw_x;
    wnd->miny=wnd->nw_y;
    wnd->maxx=wnd->nw_x+wnd->width-1;
    wnd->maxy=wnd->nw_y+wnd->height-1;
    new_buffer=_mw_save_screen_under_window_to_buffer(wnd);
    _mw_set_range(wnd);
    return(new_buffer);
}
#include "mw.h"
#pragma inline

void mw_scroll_up(WINDOW *wnd)
{
int row;
int col;
union element far *old_address;
union element far *new_address;

    for (row = 1; row < wnd->height; row++)
    {
        old_address=VIDEO_ADDRESS(wnd,0,row);
        new_address=VIDEO_ADDRESS(wnd,0,row-1);
        _CX = wnd->width;
        asm push ds
        asm push es
        asm push si
        asm push di
        asm lds si,old_address
        asm les di,new_address
        asm cld
        asm rep movsw
        asm pop di
        asm pop si
        asm pop es
        asm pop ds
    }
    for (col = 0; col < wnd->width; col++)
        VIDEO_POKE(wnd, col, wnd->height-1, ' ', wnd->wcolor[NORMAL]) ;
}


void mw_scroll_down(WINDOW *wnd)
{
int row;
int col;
union element far *old_address;
union element far *new_address;

    for (row = wnd->height-2; row > 0; --row)
    {
        old_address=VIDEO_ADDRESS(wnd,0,row);
        new_address=VIDEO_ADDRESS(wnd,0,row+1);
        _CX = wnd->width;
        asm push ds
        asm push es
        asm push si
        asm push di
        asm lds si,old_address
        asm les di,new_address
        asm cld
        asm rep movsw
        asm pop di
        asm pop si
        asm pop es
        asm pop ds
    }
    for (col = 0; col < wnd->width; col++)
        VIDEO_POKE(wnd, col, 0, ' ', wnd->wcolor[NORMAL]) ;
}
#include <stdio.h>
#include "mw.h"

mw_select(WINDOW *window)
{
int *return_values;
int *highlighted_char_columns;
char *hot_keys;
int row;
int key;
int i;

    hot_keys=window->utility_1;
    return_values=window->utility_2;
    highlighted_char_columns=window->utility_3;
    if (highlighted_char_columns != NULL)
    {
        for (row=0;row<window->height;row++)
            VIDEO_POKE_ATTRIBUTE(window,highlighted_char_columns[row],row,window->wcolor[HIGHLIGHTED]);
    }

    while (TRUE)
    {
        row=window->selection_pointer;
        mw_accent_line(window,window->wcolor[SELECTED]);
        if (highlighted_char_columns != NULL)
            VIDEO_POKE_ATTRIBUTE(window,highlighted_char_columns[row],row,window->wcolor[HIGHLIGHTED_SELECTED]);
        key=mw_get_char();
        mw_accent_line(window,window->wcolor[NORMAL]);
        if (highlighted_char_columns != NULL)
            VIDEO_POKE_ATTRIBUTE(window,highlighted_char_columns[row],row,window->wcolor[HIGHLIGHTED]);
        if (hot_keys != NULL)
        {
            for (i=0;i<window->height;i++)
                if (toupper(key)==toupper(hot_keys[i]))
                {
                    if (return_values != NULL)
                        return(return_values[i]);
                    else
                        return(i);
                }
        }
        switch (key)
        {
            case UP:
                if (window->selection_pointer > 0)
                    window->selection_pointer--;
                else
                    window->selection_pointer = window->height-1;
                break ;

            case DOWN:
                window->selection_pointer++;
                if (window->selection_pointer==window->height)
                    window->selection_pointer = 0;
                break ;
            case '\r' :
                if (return_values != NULL)
                    return(return_values[row]);
                else
                    return(row);
            case ESC :
                return(-1);
                break;

        }
    }
}
#include "mw.h"

void mw_set_shadow(WINDOW *wnd, int shadow)
{
    if (shadow)
        _mw_add_shadow(wnd);
    else
        _mw_remove_shadow(wnd);
}

static _mw_remove_shadow(WINDOW *wnd)
{
int rows;
int cols;


/*  First take the saved data under the shadow and restore it to the screen */

    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        rows=wnd->maxy - wnd->miny + 1;
        cols=wnd->maxx - wnd->minx + 1;
        _mw_restore_column_to_screen(wnd,cols-1,0,rows-2);
        _mw_restore_row_to_screen(wnd,rows-1,0,cols-1);

/* Now the buffer is fiddled with to remove the shadow so it fits the new size*/

        if (!_mw_resize(wnd,-1,-1,0,0,0,0))
        {
            _mw_draw_frame(wnd);
            return;
        }
    }
/*  Finally, reset the range so that everything else will now work properly */

    wnd->shadow=FALSE;
    _mw_set_range(wnd);
}

static _mw_add_shadow(WINDOW *wnd)
{
int rows;
int cols;
int row;
int col;
union element *save_address;

    if (wnd->maxx==79 || wnd->maxy==24)
    {
        mw_error_message("No room to add a shadow here!");
        return;
    }

    wnd->shadow=TRUE;
    if (wnd->status != WINDOW_STATUS_VISIBLE)
    {
        _mw_set_range(wnd);
        return;
    }

/*  First, the buffer is remapped to accomodate the shadow to be stored there */

    if (!_mw_resize(wnd,1,1,0,0,0,0))
    {
        wnd->shadow=FALSE;
        return;
    }
/*  Now the buffer is ready to have the area under the shadow saved into it  */

    _mw_set_range(wnd);
    rows=wnd->maxy - wnd->miny + 1;
    cols=wnd->maxx - wnd->minx + 1;
    _mw_save_column_to_buffer(wnd,cols-1,0,rows-2);
    _mw_save_row_to_buffer(wnd,rows-1,0,cols-1);

/*  Now draw the shadow, everything is ready                                  */

    _mw_draw_frame(wnd);
}
#include <alloc.h>
#include "mw.h"

int mw_grow_right(WINDOW *wnd)
{
int rows;
int cols;
int row;

    if (wnd->maxx==79)
    {
        mw_error_message("No room to grow that way");
        return(FALSE);
    }
    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        if (!_mw_resize(wnd,0,1,0,0,0,0))
            return(FALSE);

/*  Now I save the area to be covered into the new buffer                     */

        wnd->width++;
        _mw_set_range(wnd);
        rows=wnd->maxy-wnd->miny+1;
        cols=wnd->maxx-wnd->minx+1;
        _mw_save_column_to_buffer(wnd,cols-1,0,rows-1);

/*  Now I paint out the section I am adding to the window                     */

        for (row=0;row<rows;row++)
            mw_screen[wnd->miny+row][wnd->nw_x+wnd->width-1].word=VIDEO_WORD(' ',wnd->wcolor[NORMAL]);
    }
    else
    {
        wnd->width++;
        _mw_set_range(wnd);
    }
    _mw_draw_frame(wnd);
    return(TRUE);
}

int mw_grow_left(WINDOW *wnd)
{
int rows;
int row;

    if (mw_move_left(wnd))
        return(mw_grow_right(wnd));
    else
        return(FALSE);
}

int mw_grow_down(WINDOW *wnd)
{
int rows;
int cols;
int col;

    if (wnd->maxy==24)
    {
        mw_error_message("No room to grow that way");
        return(FALSE);
    }
    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        if (!_mw_resize(wnd,1,0,0,0,0,0))
            return(FALSE);

/*  Now I save the area to be covered into the new buffer                     */

        wnd->height++;
        _mw_set_range(wnd);
        rows=wnd->maxy-wnd->miny+1;
        cols=wnd->maxx-wnd->minx+1;
        _mw_save_row_to_buffer(wnd,rows-1,0,cols-1);

/*  Now I paint out the section I am adding to the window                     */

        for (col=0;col<cols;col++)
            mw_screen[wnd->nw_y+wnd->height-1][wnd->minx+col].word=VIDEO_WORD(' ',wnd->wcolor[NORMAL]);
    }
    else
    {
        wnd->height++;
        _mw_set_range(wnd);
    }
    _mw_draw_frame(wnd);
    return(TRUE);
}

int mw_grow_up(WINDOW *wnd)
{

    if (mw_move_up(wnd))
        return(mw_grow_down(wnd));
    else
        return(FALSE);
}

int mw_shrink_up(WINDOW *wnd)
{
int rows;
int cols;

    if (wnd->height==1)
    {
        mw_error_message("Can't shrink any more");
        return(FALSE);
     }
    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        rows=wnd->maxy-wnd->miny+1;
        cols=wnd->maxx-wnd->minx+1;
        _mw_restore_row_to_screen(wnd,rows-1,0,cols-1);
        if (!_mw_resize(wnd,-1,0,0,0,0,0))
        {
            _mw_draw_frame(wnd);
            return(FALSE);
        }
    }
    wnd->height--;
    _mw_set_range(wnd);
    _mw_draw_frame(wnd);
    if (wnd->cursor_y >= wnd->height)
    {
        wnd->cursor_y=wnd->height-1;
        _mw_display_cursor(wnd);
    }
    return(TRUE);
}

int mw_shrink_down(WINDOW *wnd)
{
     if (mw_shrink_up(wnd))
         return(mw_move_down(wnd));
     else
         return(FALSE);
}

int mw_shrink_left(WINDOW *wnd)
{
int rows;
int cols;

    if (wnd->width==1)
    {
        mw_error_message("Can't shrink any more");
        return(FALSE);
     }
    if (wnd->status == WINDOW_STATUS_VISIBLE)
    {
        rows=wnd->maxy-wnd->miny+1;
        cols=wnd->maxx-wnd->minx+1;
        _mw_restore_column_to_screen(wnd,cols-1,0,rows-1);
        if (!_mw_resize(wnd,0,-1,0,0,0,0))
        {
            _mw_draw_frame(wnd);
            return(FALSE);
        }
    }
    wnd->width--;
    _mw_set_range(wnd);
    _mw_draw_frame(wnd);
    if (wnd->cursor_x >= wnd->width)
    {
        wnd->cursor_x=wnd->width-1;
        _mw_display_cursor(wnd);
    }
    return(TRUE);
}

int mw_shrink_right(WINDOW *wnd)
{
     if (mw_shrink_left(wnd))
         return(mw_move_right(wnd));
     else
         return(FALSE);
}

#include <stdio.h>
#include "mw.h"

int mw_windows_initialized=FALSE;
union element (far *mw_screen)[SCREEN_WIDTH];
int mw_video_mode;

WINDOW *mw_head = NULL ;
WINDOW *mw_tail = NULL ;
